<?php


namespace xsframe\base;

use think\facade\Cache;
use xsframe\traits\ServiceTraits;

class BaseService extends BaseController
{
    protected $clientBaseType = 'service';
    protected $expire = 7200;
    protected $isolateModule = true; // 是否隔离模块

    /**
     * 引入后台通用的traits
     */
    use ServiceTraits;

    // 初始化
    protected function _initialize()
    {
        parent::_initialize(); // TODO: Change the autogenerated stub

        if (method_exists($this, '_service_initialize')) {
            $this->_service_initialize();
        }
    }

    // 初始化
    protected function _service_initialize()
    {

    }

    // 获取KEY
    protected function getKey($key): string
    {
        return ($this->isolateModule ? strtolower($this->module) . "_" : '') . md5($this->uniacid . $key);
    }

    // 设置缓存
    protected function setCache($key, $data, $expire = null): bool
    {
        return Cache::set($key, $data, $expire ?? $this->expire);
    }

    // 获取缓存
    protected function getCache($key)
    {
        return Cache::get($key);
    }

    // 清空缓存
    protected function clearCache($key)
    {
        Cache::set($key, false, -100);
    }
}