<?php


namespace xsframe\enum;

use xsframe\base\BaseEnum;

class AppCategoryKeyEnum extends BaseEnum
{
    const BUSINESS_CODE = 'business'; // 主要业务
    const CUSTOMER_CODE = 'customer'; // 客户关系
    const ACTIVITY_CODE = 'activity'; // 营销及活动
    const SERVICES_CODE = 'services'; // 常用服务及工具
    const BIZ_CODE = 'biz';// 行业解决方案
    const SALE_CODE = 'sale';// 营销类
    const TOOL_CODE = 'tool';// 工具类
    const HELP_CODE = 'help';// 辅助类
    const ENTERPRISE_CODE = 'enterprise'; // 企业应用
    const H5GAME_CODE = 'h5game'; // H5游戏
    const OTHER_CODE = 'other'; // 其他

    // 获取全部名称
    public static function getEnumsText()
    {
        $enumsValuesList = parent::getEnumsValues();
        $newEnumsList = [];

        foreach ($enumsValuesList as $key => $item) {
            $newEnumsList[$item] = self::getText($item);
        }
        return $newEnumsList;
    }

    /**
     * 获取文本列表
     * @param string $typeString
     * @return array
     */
    public static function getTextArray(string $typeString): array
    {
        $appTypes = explode(",", $typeString);
        $newAppTypes = [];
        foreach ($appTypes as $type) {
            $newAppTypes[$type] = self::getText($type);
        }
        return $newAppTypes;
    }

    /**
     * 获得应用分类文字
     *
     * @param int $reason
     * @return string
     */
    public static function getText(string $type): string
    {
        $list = [
            self::BUSINESS_CODE   => '主要业务',
            self::CUSTOMER_CODE   => '客户关系',
            self::ACTIVITY_CODE   => '营销及活动',
            self::SERVICES_CODE   => '常用服务及工具',
            self::BIZ_CODE        => '行业解决方案',
            self::SALE_CODE       => '营销类',
            self::TOOL_CODE       => '工具类',
            self::HELP_CODE       => '辅助类',
            self::ENTERPRISE_CODE => '企业应用',
            self::H5GAME_CODE     => 'H5游戏',
            self::OTHER_CODE      => '其他',
        ];
        return array_key_exists($type, $list) ? $list[$type] : '';
    }

    /**
     * 获取应用分类的全部类型值
     * @param bool $format
     * @return array|mixed
     * @throws \ReflectionException
     */
    public static function getEnumsValues(bool $format = true)
    {
        return parent::getEnumsValues($format); // TODO: Change the autogenerated stub
    }
}